# Write Orbis Address Data ------------------------------------------------

# Large data file: 112 GB on disk -> use data.table or arrow
addresses_all = fread(file = "Data/All_addresses.txt",
                      select = c(1, 10, 11, 13, 14, 19),
                      encoding = "UTF-8")

# Only need German firms
addresses_all = addresses_all[`Country ISO code` == "DE"]

# parquet files are very memory efficient ~ 5% of a dta file
# Can also query a parquet file (pre-filter/select without loading everything in)
write_parquet(addresses_all, sink = "Data/addresses_all.parquet")

rm(addresses_all)
gc()